<?php

/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;

use logicaldoc\LDOCWebServicesFactory;

jimport('joomla.application.component.controller');

/**
 * LogicalDOCControllerConfiguration
 * @author sochoa<sochoa@logicaldoc.com>
 */
class LogicalDOCControllerConfiguration extends JControllerLegacy {

    private $ws; 
    
    public function display($cachable = false, $urlparams = false) {
        parent::display($cachable, $urlparams);
    }

    public function getURI($host) {
        if (substr($host, strlen($host) - 1, strlen($host)) == '/') {
            return substr($host, 0, strlen($host) - 1);
        } else {
            return $host;
        }
    }

    public function search() {
        require_once (JPATH_COMPONENT . DS . 'tables' . DS . 'configuration.php');
        $row = JTable::getInstance('Configuration', 'Table');        
        if (!$row->bind(JRequest::get('post'))) {
            JError::raiseError(500, $row->getError());
        }
        $idConfiguration = JRequest::getVar('idConfiguration');
        $password = '';        
        $passwordAccess = '';
        if ($idConfiguration != '') {
            require_once (JPATH_COMPONENT . DS . 'tables' . DS . 'configuration.php');
            $rowConfiguration = JTable::getInstance('Configuration', 'Table');        
            $rowConfiguration->load($idConfiguration);
            $password = $rowConfiguration->password;
            $passwordAccess = $rowConfiguration->passwordAccess;
            $passwordBind = $row->password;
            if ($passwordBind == '') {
                $row->password = $password;
            }
            $passwordAccessBind = $row->passwordAccess;
            if ($passwordAccessBind == '') {
                $row->passwordAccess = $passwordAccess;
            }
        }
        $url = JRequest::getVar('url');
        $ldocPath = JRequest::getVar('ldocPath');
        $row->url = $this->getURI($url);
        $row->ldocPath = $this->getURI($ldocPath);
        if (!$row->store()) {
            JError::raiseError(500, $row->getError());
        }
        
        $idConfiguration = $row->idConfiguration;
        /**
         * Metadata
         */
        require_once (JPATH_COMPONENT . DS . 'models' . DS . 'metadata.php');
        $modelMetadata = new LogicalDOCModelMetadata();
        $rowsMetadata = $modelMetadata->getObjects($idConfiguration);
        
        foreach ($rowsMetadata as $rowMetadata) {
            require_once (JPATH_COMPONENT . DS . 'tables' . DS . 'metadata.php');
            $row = JTable::getInstance('Metadata', 'Table');
            $row->idMetadata = $rowMetadata->idMetadata;
            if (!$row->delete()) {
                JError::raiseError(500, $row->getError());
            }
        }
        //get var post
        $post = JRequest::get('post');
        $row = array();
        $i = 0;
        foreach ($post as $key => $value) {
            if (substr($key, 0, 5) == 'field') {
                $row[$i] = $value;
                $i++;
            }
            if ($i == 2) {
                $i = 0;
                require_once (JPATH_COMPONENT . DS . 'tables' . DS . 'metadata.php');
                $rowMetadata = JTable::getInstance('Metadata', 'Table');
                $rowMetadata->idConfiguration = $idConfiguration;
                $rowMetadata->property = $row[0];
                $rowMetadata->title = $row[1];
                if (!$rowMetadata->store()) {
                    JError::raiseError(500, $rowMetadata->getError());
                }
            }
        }
        
        $this->setRedirect('index.php?option=com_logicaldoc&view=configuration&layout=listconfiguration', JText::_('COM_LOGICALDOC_GUARDED'));
    }

    public function delete() {
        $idConfiguration = JRequest::getVar('id');
        require_once (JPATH_COMPONENT . DS . 'models' . DS . 'metadata.php');
        $modelMetadata = new LogicalDOCModelMetadata();
        $rowsMetadata = $modelMetadata->getObjects($idConfiguration);
        foreach ($rowsMetadata as $rowMetadata) {
            require_once (JPATH_COMPONENT . DS . 'tables' . DS . 'metadata.php');
            $row = JTable::getInstance('Metadata', 'Table');
            $row->idMetadata = $rowMetadata->idMetadata;
            if (!$row->delete()) {
                JError::raiseError(500, $row->getError());
            }
        }
        require_once (JPATH_COMPONENT . DS . 'tables' . DS . 'configuration.php');
        $row = JTable::getInstance('Configuration', 'Table');
        $row->idConfiguration = JRequest::getVar('id');
        if (!$row->delete()) {
            JError::raiseError(500, $row->getError());
        }
        $this->setRedirect('index.php?option=com_logicaldoc&view=configuration&layout=listconfiguration', JText::_('COM_LOGICALDOC_DELETED'));
    }

    public function edit() {
        JRequest::setVar('view', 'configuration');
        JRequest::setVar('layout', 'formconfiguration');
        $this->display();
    }

    public function test() {
        require_once (JPATH_COMPONENT . DS . 'tables' . DS . 'configuration.php');
        $row = JTable::getInstance('Configuration', 'Table');
        $id= JRequest::getVar('id');
        $row->load($id);        
        $welcome = '';
        $message = '';
        $error = '';
        try {
            $this->ws = LDOCWebServicesFactory::build($row->url, $row->user, $row->password);
            //$welcome = JText::_('COM_LOGICALDOC_WELCOME') . ' ' . $this->ws->getName($row->user);
			$welcome = 'Session ID: ' . ' ' . $this->ws->getName($row->user);
            $message = JText::_('COM_LOGICALDOC_CONNECTION_SUCCEEDED');
		} catch (Throwable $t) {
			// Executed only in PHP 7, will not match in PHP 5.x
		    error_log("Thowable error");
			error_log("Caught Throwable: $t");
            $message = '<p>' . JText::_('COM_LOGICALDOC_CANNOT_ESTABLISH_A_CONNECTION') . '</p>';
            $error = $t->getMessage();			
        } catch (Exception $e) {
			error_log("Caught Exception: $e");
            $message = '<p>' . JText::_('COM_LOGICALDOC_CANNOT_ESTABLISH_A_CONNECTION') . '</p>';
            $error = $e->getMessage();
        }
        JRequest::setVar('view', 'configuration');
        JRequest::setVar('layout', 'message');
        JRequest::setVar('format', 'raw');
        JRequest::setVar('welcome', $welcome);
        JRequest::setVar('message', $message);
        JRequest::setVar('error', $error);
        $this->display();
    }

    public function cancel() {
        $this->setRedirect('index.php?option=com_logicaldoc&view=configuration&layout=listconfiguration');
    }

}

?>
