<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */

/**
 * WSFolder
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * LogicalDOC REST API
 *
 * This is the interactive documentation of the REST APIs exposed by LogicalDOC. You can find more information about LogicalDOC at <a href=\"https://www.logicaldoc.com\">https://www.logicaldoc.com</a> or on Twitter @logicaldoc.<br/>                Note: The access path to the API is protected with basic authentication, to be able to run the samples you must log in using the credentials of a Logicaldoc user, or passing to the request the session ID (SID) as a cookie (cookie name: `ldoc-sid`).<br/><br/>             Here is an example to list the children folders: <br/> <pre>curl -u admin:admin -H 'Accept: application/json' http://localhost:8080/services/rest/folder/listChildren?folderId=4</pre><br/><br/>RESTful Guide with curl:  <a href='https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl'>https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl</a> <br/><br/>Practical examples of use are available for various programming languages at: <a href='http://wiki.logicaldoc.com/wiki/Bindings_And_Samples'>http://wiki.logicaldoc.com/wiki/Bindings_And_Samples</a>
 *
 * OpenAPI spec version: 8.6.0-oas3
 * Contact: devel@logicaldoc.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.33
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

defined('_JEXEC') or die('Restricted access');


use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * WSFolder Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class WSFolder implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'WSFolder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'id' => 'int',
'name' => 'string',
'parent_id' => 'int',
'description' => 'string',
'last_modified' => 'string',
'type' => 'int',
'template_id' => 'int',
'template_locked' => 'int',
'creation' => 'string',
'creator' => 'string',
'position' => 'int',
'hidden' => 'int',
'fold_ref' => 'int',
'security_ref' => 'int',
'attributes' => '\Swagger\Client\Model\WSAttribute[]',
'storage' => 'int',
'tags' => 'string[]',
'ocr_template_id' => 'int',
'barcode_template_id' => 'int',
'max_versions' => 'int'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'id' => 'int64',
'name' => null,
'parent_id' => 'int64',
'description' => null,
'last_modified' => null,
'type' => 'int32',
'template_id' => 'int64',
'template_locked' => 'int32',
'creation' => null,
'creator' => null,
'position' => 'int32',
'hidden' => 'int32',
'fold_ref' => 'int64',
'security_ref' => 'int64',
'attributes' => null,
'storage' => 'int32',
'tags' => null,
'ocr_template_id' => 'int64',
'barcode_template_id' => 'int64',
'max_versions' => 'int32'    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
'name' => 'name',
'parent_id' => 'parentId',
'description' => 'description',
'last_modified' => 'lastModified',
'type' => 'type',
'template_id' => 'templateId',
'template_locked' => 'templateLocked',
'creation' => 'creation',
'creator' => 'creator',
'position' => 'position',
'hidden' => 'hidden',
'fold_ref' => 'foldRef',
'security_ref' => 'securityRef',
'attributes' => 'attributes',
'storage' => 'storage',
'tags' => 'tags',
'ocr_template_id' => 'ocrTemplateId',
'barcode_template_id' => 'barcodeTemplateId',
'max_versions' => 'maxVersions'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
'name' => 'setName',
'parent_id' => 'setParentId',
'description' => 'setDescription',
'last_modified' => 'setLastModified',
'type' => 'setType',
'template_id' => 'setTemplateId',
'template_locked' => 'setTemplateLocked',
'creation' => 'setCreation',
'creator' => 'setCreator',
'position' => 'setPosition',
'hidden' => 'setHidden',
'fold_ref' => 'setFoldRef',
'security_ref' => 'setSecurityRef',
'attributes' => 'setAttributes',
'storage' => 'setStorage',
'tags' => 'setTags',
'ocr_template_id' => 'setOcrTemplateId',
'barcode_template_id' => 'setBarcodeTemplateId',
'max_versions' => 'setMaxVersions'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
'name' => 'getName',
'parent_id' => 'getParentId',
'description' => 'getDescription',
'last_modified' => 'getLastModified',
'type' => 'getType',
'template_id' => 'getTemplateId',
'template_locked' => 'getTemplateLocked',
'creation' => 'getCreation',
'creator' => 'getCreator',
'position' => 'getPosition',
'hidden' => 'getHidden',
'fold_ref' => 'getFoldRef',
'security_ref' => 'getSecurityRef',
'attributes' => 'getAttributes',
'storage' => 'getStorage',
'tags' => 'getTags',
'ocr_template_id' => 'getOcrTemplateId',
'barcode_template_id' => 'getBarcodeTemplateId',
'max_versions' => 'getMaxVersions'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['parent_id'] = isset($data['parent_id']) ? $data['parent_id'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['last_modified'] = isset($data['last_modified']) ? $data['last_modified'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['template_id'] = isset($data['template_id']) ? $data['template_id'] : null;
        $this->container['template_locked'] = isset($data['template_locked']) ? $data['template_locked'] : null;
        $this->container['creation'] = isset($data['creation']) ? $data['creation'] : null;
        $this->container['creator'] = isset($data['creator']) ? $data['creator'] : null;
        $this->container['position'] = isset($data['position']) ? $data['position'] : null;
        $this->container['hidden'] = isset($data['hidden']) ? $data['hidden'] : null;
        $this->container['fold_ref'] = isset($data['fold_ref']) ? $data['fold_ref'] : null;
        $this->container['security_ref'] = isset($data['security_ref']) ? $data['security_ref'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['storage'] = isset($data['storage']) ? $data['storage'] : null;
        $this->container['tags'] = isset($data['tags']) ? $data['tags'] : null;
        $this->container['ocr_template_id'] = isset($data['ocr_template_id']) ? $data['ocr_template_id'] : null;
        $this->container['barcode_template_id'] = isset($data['barcode_template_id']) ? $data['barcode_template_id'] : null;
        $this->container['max_versions'] = isset($data['max_versions']) ? $data['max_versions'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return int
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param int $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets parent_id
     *
     * @return int
     */
    public function getParentId()
    {
        return $this->container['parent_id'];
    }

    /**
     * Sets parent_id
     *
     * @param int $parent_id parent_id
     *
     * @return $this
     */
    public function setParentId($parent_id)
    {
        $this->container['parent_id'] = $parent_id;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string $description description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets last_modified
     *
     * @return string
     */
    public function getLastModified()
    {
        return $this->container['last_modified'];
    }

    /**
     * Sets last_modified
     *
     * @param string $last_modified last_modified
     *
     * @return $this
     */
    public function setLastModified($last_modified)
    {
        $this->container['last_modified'] = $last_modified;

        return $this;
    }

    /**
     * Gets type
     *
     * @return int
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param int $type type
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets template_id
     *
     * @return int
     */
    public function getTemplateId()
    {
        return $this->container['template_id'];
    }

    /**
     * Sets template_id
     *
     * @param int $template_id template_id
     *
     * @return $this
     */
    public function setTemplateId($template_id)
    {
        $this->container['template_id'] = $template_id;

        return $this;
    }

    /**
     * Gets template_locked
     *
     * @return int
     */
    public function getTemplateLocked()
    {
        return $this->container['template_locked'];
    }

    /**
     * Sets template_locked
     *
     * @param int $template_locked template_locked
     *
     * @return $this
     */
    public function setTemplateLocked($template_locked)
    {
        $this->container['template_locked'] = $template_locked;

        return $this;
    }

    /**
     * Gets creation
     *
     * @return string
     */
    public function getCreation()
    {
        return $this->container['creation'];
    }

    /**
     * Sets creation
     *
     * @param string $creation creation
     *
     * @return $this
     */
    public function setCreation($creation)
    {
        $this->container['creation'] = $creation;

        return $this;
    }

    /**
     * Gets creator
     *
     * @return string
     */
    public function getCreator()
    {
        return $this->container['creator'];
    }

    /**
     * Sets creator
     *
     * @param string $creator creator
     *
     * @return $this
     */
    public function setCreator($creator)
    {
        $this->container['creator'] = $creator;

        return $this;
    }

    /**
     * Gets position
     *
     * @return int
     */
    public function getPosition()
    {
        return $this->container['position'];
    }

    /**
     * Sets position
     *
     * @param int $position position
     *
     * @return $this
     */
    public function setPosition($position)
    {
        $this->container['position'] = $position;

        return $this;
    }

    /**
     * Gets hidden
     *
     * @return int
     */
    public function getHidden()
    {
        return $this->container['hidden'];
    }

    /**
     * Sets hidden
     *
     * @param int $hidden hidden
     *
     * @return $this
     */
    public function setHidden($hidden)
    {
        $this->container['hidden'] = $hidden;

        return $this;
    }

    /**
     * Gets fold_ref
     *
     * @return int
     */
    public function getFoldRef()
    {
        return $this->container['fold_ref'];
    }

    /**
     * Sets fold_ref
     *
     * @param int $fold_ref fold_ref
     *
     * @return $this
     */
    public function setFoldRef($fold_ref)
    {
        $this->container['fold_ref'] = $fold_ref;

        return $this;
    }

    /**
     * Gets security_ref
     *
     * @return int
     */
    public function getSecurityRef()
    {
        return $this->container['security_ref'];
    }

    /**
     * Sets security_ref
     *
     * @param int $security_ref security_ref
     *
     * @return $this
     */
    public function setSecurityRef($security_ref)
    {
        $this->container['security_ref'] = $security_ref;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Swagger\Client\Model\WSAttribute[]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Swagger\Client\Model\WSAttribute[] $attributes attributes
     *
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets storage
     *
     * @return int
     */
    public function getStorage()
    {
        return $this->container['storage'];
    }

    /**
     * Sets storage
     *
     * @param int $storage storage
     *
     * @return $this
     */
    public function setStorage($storage)
    {
        $this->container['storage'] = $storage;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return string[]
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param string[] $tags tags
     *
     * @return $this
     */
    public function setTags($tags)
    {
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets ocr_template_id
     *
     * @return int
     */
    public function getOcrTemplateId()
    {
        return $this->container['ocr_template_id'];
    }

    /**
     * Sets ocr_template_id
     *
     * @param int $ocr_template_id ocr_template_id
     *
     * @return $this
     */
    public function setOcrTemplateId($ocr_template_id)
    {
        $this->container['ocr_template_id'] = $ocr_template_id;

        return $this;
    }

    /**
     * Gets barcode_template_id
     *
     * @return int
     */
    public function getBarcodeTemplateId()
    {
        return $this->container['barcode_template_id'];
    }

    /**
     * Sets barcode_template_id
     *
     * @param int $barcode_template_id barcode_template_id
     *
     * @return $this
     */
    public function setBarcodeTemplateId($barcode_template_id)
    {
        $this->container['barcode_template_id'] = $barcode_template_id;

        return $this;
    }

    /**
     * Gets max_versions
     *
     * @return int
     */
    public function getMaxVersions()
    {
        return $this->container['max_versions'];
    }

    /**
     * Sets max_versions
     *
     * @param int $max_versions max_versions
     *
     * @return $this
     */
    public function setMaxVersions($max_versions)
    {
        $this->container['max_versions'] = $max_versions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
