<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */

/**
 * FolderCopyBody
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * LogicalDOC REST API
 *
 * This is the interactive documentation of the REST APIs exposed by LogicalDOC. You can find more information about LogicalDOC at <a href=\"https://www.logicaldoc.com\">https://www.logicaldoc.com</a> or on Twitter @logicaldoc.<br/>                Note: The access path to the API is protected with basic authentication, to be able to run the samples you must log in using the credentials of a Logicaldoc user, or passing to the request the session ID (SID) as a cookie (cookie name: `ldoc-sid`).<br/><br/>             Here is an example to list the children folders: <br/> <pre>curl -u admin:admin -H 'Accept: application/json' http://localhost:8080/services/rest/folder/listChildren?folderId=4</pre><br/><br/>RESTful Guide with curl:  <a href='https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl'>https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl</a> <br/><br/>Practical examples of use are available for various programming languages at: <a href='http://wiki.logicaldoc.com/wiki/Bindings_And_Samples'>http://wiki.logicaldoc.com/wiki/Bindings_And_Samples</a>
 *
 * OpenAPI spec version: 8.6.0-oas3
 * Contact: devel@logicaldoc.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.33
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

defined('_JEXEC') or die('Restricted access');


use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * FolderCopyBody Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class FolderCopyBody implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'folder_copy_body';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'folder_id' => 'int',
'target_id' => 'int',
'folders_only' => 'int',
'inherit_security' => 'int'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'folder_id' => 'int64',
'target_id' => 'int64',
'folders_only' => 'int32',
'inherit_security' => 'int32'    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'folder_id' => 'folderId',
'target_id' => 'targetId',
'folders_only' => 'foldersOnly',
'inherit_security' => 'inheritSecurity'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'folder_id' => 'setFolderId',
'target_id' => 'setTargetId',
'folders_only' => 'setFoldersOnly',
'inherit_security' => 'setInheritSecurity'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'folder_id' => 'getFolderId',
'target_id' => 'getTargetId',
'folders_only' => 'getFoldersOnly',
'inherit_security' => 'getInheritSecurity'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['folder_id'] = isset($data['folder_id']) ? $data['folder_id'] : null;
        $this->container['target_id'] = isset($data['target_id']) ? $data['target_id'] : null;
        $this->container['folders_only'] = isset($data['folders_only']) ? $data['folders_only'] : null;
        $this->container['inherit_security'] = isset($data['inherit_security']) ? $data['inherit_security'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['folder_id'] === null) {
            $invalidProperties[] = "'folder_id' can't be null";
        }
        if ($this->container['target_id'] === null) {
            $invalidProperties[] = "'target_id' can't be null";
        }
        if ($this->container['folders_only'] === null) {
            $invalidProperties[] = "'folders_only' can't be null";
        }
        if ($this->container['inherit_security'] === null) {
            $invalidProperties[] = "'inherit_security' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets folder_id
     *
     * @return int
     */
    public function getFolderId()
    {
        return $this->container['folder_id'];
    }

    /**
     * Sets folder_id
     *
     * @param int $folder_id Folder identifier (source)
     *
     * @return $this
     */
    public function setFolderId($folder_id)
    {
        $this->container['folder_id'] = $folder_id;

        return $this;
    }

    /**
     * Gets target_id
     *
     * @return int
     */
    public function getTargetId()
    {
        return $this->container['target_id'];
    }

    /**
     * Sets target_id
     *
     * @param int $target_id The folder ID of the target folder
     *
     * @return $this
     */
    public function setTargetId($target_id)
    {
        $this->container['target_id'] = $target_id;

        return $this;
    }

    /**
     * Gets folders_only
     *
     * @return int
     */
    public function getFoldersOnly()
    {
        return $this->container['folders_only'];
    }

    /**
     * Sets folders_only
     *
     * @param int $folders_only If 1, only the folders will be copied and not the documents
     *
     * @return $this
     */
    public function setFoldersOnly($folders_only)
    {
        $this->container['folders_only'] = $folders_only;

        return $this;
    }

    /**
     * Gets inherit_security
     *
     * @return int
     */
    public function getInheritSecurity()
    {
        return $this->container['inherit_security'];
    }

    /**
     * Sets inherit_security
     *
     * @param int $inherit_security If 1, the new folders will inherit the target's security policies
     *
     * @return $this
     */
    public function setInheritSecurity($inherit_security)
    {
        $this->container['inherit_security'] = $inherit_security;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
