<?php

/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;

use logicaldoc\LDOCWebServicesFactory;
use \Swagger\Client\Model\WSSearchOptions;
/*
use logicaldoc\bean\QueryParams;
use logicaldoc\bean\ResultSet;
*/

jimport('joomla.application.component.view');

class LogicalDOCViewSearch extends JViewLegacy {

    private $ws;

    public function display($tpl = null) {
        $layout = JRequest::getVar('layout');
        $error = 0;
        require_once(JPATH_COMPONENT . DS . 'tables' . DS . 'configuration.php');
        $rowConfiguration = JTable::getInstance('Configuration', 'Table');
        $id = JRequest::getVar('id');
        $rowConfiguration->load($id);
        $url = $rowConfiguration->url;
        $user = $rowConfiguration->user;
        $password = $rowConfiguration->password;
        $this->assignRef('rowConfiguration', $rowConfiguration);
        //Metadata
        require_once (JPATH_COMPONENT . DS . 'models' . DS . 'metadata.php');
        $modelMetadata = new LogicalDOCModelMetadata();
        $rowsMetadata = $modelMetadata->getObjects($rowConfiguration->idConfiguration);
        $this->assignRef('rowsMetadata', $rowsMetadata);
        if ($layout == 'result') {
            try {
                $content = JRequest::getVar('content');
				$documentType = JRequest::getVar('documentType');
				$sfields = JRequest::getVar('sfields');
				$maxHits = JRequest::getVar('maxHits');
				if (empty($maxHits))
					$maxHits = 40;
                
                $this->ws = LDOCWebServicesFactory::build($url, $user, $password);              
				
				$soptions = new WSSearchOptions();
				$soptions->setExpression($content);
				$soptions->setExpressionLanguage('en');
				$soptions->setMaxHits($maxHits);
				$soptions->setFolderId($rowConfiguration->ldocPath);
				$soptions->setSearchInSubPath(1);
								
				if (isset($sfields) && !empty($sfields)) {					
					$soptions->setFields($sfields);					
                } else {
                    // user searched from the simple search (just filling the field content)
					$sfields = array('content', 'title', 'tags');
					$soptions->setFields($sfields);					
                }								
				
                $sessionSearch = JFactory::getSession();
                $sessionSearch->set('content', $content);
				$sessionSearch->set('documentType', $documentType);
				$sessionSearch->set('sfields', $sfields);
				$sessionSearch->set('maxHits', $maxHits);
				
				$searchResult = $this->ws->find($soptions);

				if (!empty($searchResult->getHits())) {
					$resultArray = $searchResult->getHits();
					if (is_array($resultArray)) {
						
						// filter the results by file extension
						if (!empty($documentType)) {
							$fdocs = $resultArray;
							$resultArray = array();
							
							for ($i = 0; $i < count($fdocs); $i++) {
								$docext = $fdocs[$i]->getType();						
								$docext = strtolower($docext);
								if (strpos($documentType, $docext) !== false) {
									$resultArray[] = $fdocs[$i];
								} 
							}
						}						
					}
				}										
				
            } catch (Throwable $t) {
                $error = 1;
                $this->assignRef('ldocMessage', $t->getMessage());				
			} catch (Exception $e) {
                $error = 1;
                $this->assignRef('ldocMessage', $e->getMessage());
            }
			$this->assignRef('error', $error);
            $this->assignRef('sessionSearch', $sessionSearch);
			$this->assignRef('resultArray', $resultArray); 
        }
        parent::display($tpl);
    }

}

?>
