kQuery(function($) {

    'user strict';

    $.fn.renderPlayers = function () {

        var links = $('div[itemprop="articleBody"]').find('a');

        links.each(function(index, link){

            var path = $(link).attr('href');

            $.urlParams = function(variable) {
                var query = path;
                var vars = query.split('&');
                for (var i = 0; i < vars.length; i++) {
                    var pair = vars[i].split('=');
                    if (decodeURIComponent(pair[0]) == variable) {
                        return decodeURIComponent(pair[1]);
                    }
                }
                return '';
            };

            $.audioPlayer = function(path, mime) {
                return '<audio controls><source src="' + path + '" type="audio/' + mime + '" /></audio>';
            };

            $.videoPlayer = function(path, mime) {
                return '<video controls><source src="' + path + '" type="video/' + mime + '" /></video>';
            };

            if ( $.urlParams('container') == 'fileman-files' ) {

                var name = $.urlParams('name');

                if (name && name.indexOf("mp3") >= 0) {
                    $(link).replaceWith($.audioPlayer(path, 'mp3'));
                }

                if (name && name.indexOf("mp4") >= 0) {
                    $(link).replaceWith($.videoPlayer(path, 'mp4'));
                }
            }

        });

        plyr.setup();
    };

    $("body").renderPlayers();
});