<?php
/**
 * @package     FILEman
 * @copyright   Copyright (C) 2011 Timble CVBA (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

class ComFilemanViewBehaviorPageable extends KViewBehaviorAbstract
{
    /**
     * A reference to the menu or module parameters
     */
    protected $_parameters;

    /**
     * Get menu parameters
     */
    public function getParameters()
    {
        if (!isset($this->_parameters)) {
            $this->setParameters($this->getActiveMenu()->getParams());
        }

        return $this->_parameters;
    }

    public function setParameters($parameters)
    {
        if (!($parameters instanceof ComKoowaDecoratorParameter) && !($parameters instanceof KObjectConfigInterface)) {
            $parameters = new ComKoowaDecoratorParameter(new KObjectConfig(array('delegate' => $parameters)));
        }

        $this->_parameters = $parameters;

        return $this;
    }

    /**
     * Returns currently active menu item
     *
     * Default menu item for the site will be returned if there is no active menu items
     *
     * @return object
     */
    public function getActiveMenu()
    {
        $menu = JFactory::getApplication()->getMenu()->getActive();
        if (is_null($menu)) {
            $menu = JFactory::getApplication()->getMenu()->getDefault();
        }

        return $menu;
    }
}