<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */

/**
 * WSCriterion
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * LogicalDOC REST API
 *
 * This is the interactive documentation of the REST APIs exposed by LogicalDOC. You can find more information about LogicalDOC at <a href=\"https://www.logicaldoc.com\">https://www.logicaldoc.com</a> or on Twitter @logicaldoc.<br/>                Note: The access path to the API is protected with basic authentication, to be able to run the samples you must log in using the credentials of a Logicaldoc user, or passing to the request the session ID (SID) as a cookie (cookie name: `ldoc-sid`).<br/><br/>             Here is an example to list the children folders: <br/> <pre>curl -u admin:admin -H 'Accept: application/json' http://localhost:8080/services/rest/folder/listChildren?folderId=4</pre><br/><br/>RESTful Guide with curl:  <a href='https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl'>https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl</a> <br/><br/>Practical examples of use are available for various programming languages at: <a href='http://wiki.logicaldoc.com/wiki/Bindings_And_Samples'>http://wiki.logicaldoc.com/wiki/Bindings_And_Samples</a>
 *
 * OpenAPI spec version: 8.6.0-oas3
 * Contact: devel@logicaldoc.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.33
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

defined('_JEXEC') or die('Restricted access');


use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * WSCriterion Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class WSCriterion implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'WSCriterion';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'field' => 'string',
'composition' => 'string',
'operator' => 'string',
'string_value' => 'string',
'date_value' => '\DateTime',
'int_value' => 'int',
'double_value' => 'double',
'extended_attribute' => 'int',
'type' => 'int'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'field' => null,
'composition' => null,
'operator' => null,
'string_value' => null,
'date_value' => 'date-time',
'int_value' => 'int64',
'double_value' => 'double',
'extended_attribute' => 'int32',
'type' => 'int32'    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'field' => 'field',
'composition' => 'composition',
'operator' => 'operator',
'string_value' => 'stringValue',
'date_value' => 'dateValue',
'int_value' => 'intValue',
'double_value' => 'doubleValue',
'extended_attribute' => 'extendedAttribute',
'type' => 'type'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'field' => 'setField',
'composition' => 'setComposition',
'operator' => 'setOperator',
'string_value' => 'setStringValue',
'date_value' => 'setDateValue',
'int_value' => 'setIntValue',
'double_value' => 'setDoubleValue',
'extended_attribute' => 'setExtendedAttribute',
'type' => 'setType'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'field' => 'getField',
'composition' => 'getComposition',
'operator' => 'getOperator',
'string_value' => 'getStringValue',
'date_value' => 'getDateValue',
'int_value' => 'getIntValue',
'double_value' => 'getDoubleValue',
'extended_attribute' => 'getExtendedAttribute',
'type' => 'getType'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['field'] = isset($data['field']) ? $data['field'] : null;
        $this->container['composition'] = isset($data['composition']) ? $data['composition'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['string_value'] = isset($data['string_value']) ? $data['string_value'] : null;
        $this->container['date_value'] = isset($data['date_value']) ? $data['date_value'] : null;
        $this->container['int_value'] = isset($data['int_value']) ? $data['int_value'] : null;
        $this->container['double_value'] = isset($data['double_value']) ? $data['double_value'] : null;
        $this->container['extended_attribute'] = isset($data['extended_attribute']) ? $data['extended_attribute'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets field
     *
     * @return string
     */
    public function getField()
    {
        return $this->container['field'];
    }

    /**
     * Sets field
     *
     * @param string $field field
     *
     * @return $this
     */
    public function setField($field)
    {
        $this->container['field'] = $field;

        return $this;
    }

    /**
     * Gets composition
     *
     * @return string
     */
    public function getComposition()
    {
        return $this->container['composition'];
    }

    /**
     * Sets composition
     *
     * @param string $composition composition
     *
     * @return $this
     */
    public function setComposition($composition)
    {
        $this->container['composition'] = $composition;

        return $this;
    }

    /**
     * Gets operator
     *
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     *
     * @param string $operator operator
     *
     * @return $this
     */
    public function setOperator($operator)
    {
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets string_value
     *
     * @return string
     */
    public function getStringValue()
    {
        return $this->container['string_value'];
    }

    /**
     * Sets string_value
     *
     * @param string $string_value string_value
     *
     * @return $this
     */
    public function setStringValue($string_value)
    {
        $this->container['string_value'] = $string_value;

        return $this;
    }

    /**
     * Gets date_value
     *
     * @return \DateTime
     */
    public function getDateValue()
    {
        return $this->container['date_value'];
    }

    /**
     * Sets date_value
     *
     * @param \DateTime $date_value date_value
     *
     * @return $this
     */
    public function setDateValue($date_value)
    {
        $this->container['date_value'] = $date_value;

        return $this;
    }

    /**
     * Gets int_value
     *
     * @return int
     */
    public function getIntValue()
    {
        return $this->container['int_value'];
    }

    /**
     * Sets int_value
     *
     * @param int $int_value int_value
     *
     * @return $this
     */
    public function setIntValue($int_value)
    {
        $this->container['int_value'] = $int_value;

        return $this;
    }

    /**
     * Gets double_value
     *
     * @return double
     */
    public function getDoubleValue()
    {
        return $this->container['double_value'];
    }

    /**
     * Sets double_value
     *
     * @param double $double_value double_value
     *
     * @return $this
     */
    public function setDoubleValue($double_value)
    {
        $this->container['double_value'] = $double_value;

        return $this;
    }

    /**
     * Gets extended_attribute
     *
     * @return int
     */
    public function getExtendedAttribute()
    {
        return $this->container['extended_attribute'];
    }

    /**
     * Sets extended_attribute
     *
     * @param int $extended_attribute extended_attribute
     *
     * @return $this
     */
    public function setExtendedAttribute($extended_attribute)
    {
        $this->container['extended_attribute'] = $extended_attribute;

        return $this;
    }

    /**
     * Gets type
     *
     * @return int
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param int $type type
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
