<?php
/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;
?>

<script type="text/javascript">
    $(document).ready(function () {
        $("#dialogMessage").dialog({
            width: 500,
            modal: true,
            autoOpen: true,
            show: 'expolde',
            hide: 'explode',
            buttons: {
                OK: function () {
                    $(this).dialog('close');
                }
            }
        });

        $('#detail').button().click(function () {
            $('#error').slideDown('1000');
            $('#error').css('display', 'block');
        });

        $('#error').css('display', 'none');
    });

</script>
<!--Message-->
<div id="dialogMessage">
    <p>
        <?php echo $this->welcome; ?>
    </p>
    <p><?php echo $this->message; ?></p>
    <?php if (!empty($this->error)) { ?>
        <p> 
            <a href="#" id="detail" style="margin: 10px;"><?php echo JText::_('COM_LOGICALDOC_DETAIL_ERROR'); ?></a>
        <div class="ui-state-error ui-corner-all" style="padding: 0 .7em;" id="error">
            <p>
                <span class="ui-icon ui-icon-alert" style="float: left; margin-right: .3em;"></span>
                <strong>Alert:</strong>
                <?php echo $this->error; ?>
            </p>
        </div>    
        <?php
    }
    ?>

</div>


