<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */


namespace logicaldoc;

defined('_JEXEC') or die('Restricted access');


require_once(__DIR__ . '/vendor/autoload.php');

use Swagger\Client\Configuration;
use Swagger\Client\Api\AuthorApi;
use Swagger\Client\Api\FolderApi;
use Swagger\Client\Api\DocumentApi;
use Swagger\Client\Api\SearchApi;
use GuzzleHttp\Client;

/**
 * LDOCWebservice10
 *
 */
class LDOCWebservice10 {

	private $config;
    private $authorAPI;
	private $folderAPI;
	private $documentApi;

    public function __construct($host, $user, $password) {
		
// Configure HTTP basic authorization: basicAuth
  $this->config = Configuration::getDefaultConfiguration()
    ->setUserAgent('Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/100.0.4896.75 Safari/537.36')
	->setHost($host . '/services/rest' ) 
    ->setUsername($user)
    ->setPassword($password);

$this->authorAPI = new AuthorApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new Client(),
    $this->config
);

$this->folderAPI = new FolderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new Client(),
    $this->config
);	

$this->documentApi = new DocumentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new Client(),
    $this->config
);		

$this->searchApi = new SearchApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new Client(),
    $this->config
);	
		
    }

    /**
     * Get Name
     * 
     * @param string $user The user
     * @return string Return the name of a valid user.
     */
    public function getName($user) {
		return $this->authorAPI->getSid();
    }
	
    /**
     * Get the properties of the folder
     * @param string $fldId The uuid or path of the Folder
     * @return Folder $folder Return the folder properties
     */
    public function getFolderProperties($fldId) {
		return $this->folderAPI->getFolder($fldId);
    }

    /**
     * Get Document children
     * 
     * @param string $fldId The uuid or path of the Folder or a record node.
     * @return array Return a list of all documents which their parent is fldId.
     */
    public function getDocumentChildren($fldId) {
        return $this->documentApi->listDocuments($fldId, '*');
    }
	
    /**
     * Get document properties
     * 
     * @param string $docId The uuid or path of the Document
     * @return Document Return the document properties.
     */
    public function getDocumentProperties($docId) {
        return $this->documentApi->getDocument($docId);
    }

    /**
     * Get content
     * 
     * @param string $docId The uuid or path of the Document
     * @return string Retrieve document content - binary data - of the actual document version
     */
    public function getContent($docId) {
        return $this->documentApi->getContent($docId);
    }	


    /**
     * Get Folder Children
     * @param string $fldId The uuid or path of the Folder or Record node
     * @return array Return an array of all Folder their parent is fldId
     */
    public function getFolderChildren($fldId) {
        return $this->folderAPI->listChildren($fldId);
    }

	    /**
     * Find paginated
     * 
     * The parameter "limit" and "offset" allow you to retrieve just a portion of the results of a query.
     * 
     * @param QueryParams $queryParams
     * @param int $offset The parameter "limit" is used to limit the number of results returned.
     * @param int $limit The parameter "offset" says to skip that many results before the begining to return results.
     */
    public function find($queryParams) {
		//error_log(print_r($queryParams, true));
        return $this->searchApi->find($queryParams);
    }

}

?>
