<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */

/**
 * WSAttribute
 *
 * PHP version 5
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * LogicalDOC REST API
 *
 * This is the interactive documentation of the REST APIs exposed by LogicalDOC. You can find more information about LogicalDOC at <a href=\"https://www.logicaldoc.com\">https://www.logicaldoc.com</a> or on Twitter @logicaldoc.<br/>                Note: The access path to the API is protected with basic authentication, to be able to run the samples you must log in using the credentials of a Logicaldoc user, or passing to the request the session ID (SID) as a cookie (cookie name: `ldoc-sid`).<br/><br/>             Here is an example to list the children folders: <br/> <pre>curl -u admin:admin -H 'Accept: application/json' http://localhost:8080/services/rest/folder/listChildren?folderId=4</pre><br/><br/>RESTful Guide with curl:  <a href='https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl'>https://wiki.logicaldoc.com/wiki/RESTful_Guide_with_curl</a> <br/><br/>Practical examples of use are available for various programming languages at: <a href='http://wiki.logicaldoc.com/wiki/Bindings_And_Samples'>http://wiki.logicaldoc.com/wiki/Bindings_And_Samples</a>
 *
 * OpenAPI spec version: 8.6.0-oas3
 * Contact: devel@logicaldoc.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.33
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Swagger\Client\Model;

defined('_JEXEC') or die('Restricted access');


use \ArrayAccess;
use \Swagger\Client\ObjectSerializer;

/**
 * WSAttribute Class Doc Comment
 *
 * @category Class
 * @package  Swagger\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class WSAttribute implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'WSAttribute';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'name' => 'string',
'string_value' => 'string',
'int_value' => 'int',
'double_value' => 'double',
'date_value' => 'string',
'type' => 'int',
'mandatory' => 'int',
'hidden' => 'int',
'position' => 'int',
'label' => 'string',
'editor' => 'int',
'set_id' => 'int',
'multiple' => 'int',
'parent' => 'string',
'string_values' => 'string',
'value' => 'object'    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'name' => null,
'string_value' => null,
'int_value' => 'int64',
'double_value' => 'double',
'date_value' => null,
'type' => 'int32',
'mandatory' => 'int32',
'hidden' => 'int32',
'position' => 'int32',
'label' => null,
'editor' => 'int32',
'set_id' => 'int64',
'multiple' => 'int32',
'parent' => null,
'string_values' => null,
'value' => null    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
'string_value' => 'stringValue',
'int_value' => 'intValue',
'double_value' => 'doubleValue',
'date_value' => 'dateValue',
'type' => 'type',
'mandatory' => 'mandatory',
'hidden' => 'hidden',
'position' => 'position',
'label' => 'label',
'editor' => 'editor',
'set_id' => 'setId',
'multiple' => 'multiple',
'parent' => 'parent',
'string_values' => 'stringValues',
'value' => 'value'    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
'string_value' => 'setStringValue',
'int_value' => 'setIntValue',
'double_value' => 'setDoubleValue',
'date_value' => 'setDateValue',
'type' => 'setType',
'mandatory' => 'setMandatory',
'hidden' => 'setHidden',
'position' => 'setPosition',
'label' => 'setLabel',
'editor' => 'setEditor',
'set_id' => 'setSetId',
'multiple' => 'setMultiple',
'parent' => 'setParent',
'string_values' => 'setStringValues',
'value' => 'setValue'    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
'string_value' => 'getStringValue',
'int_value' => 'getIntValue',
'double_value' => 'getDoubleValue',
'date_value' => 'getDateValue',
'type' => 'getType',
'mandatory' => 'getMandatory',
'hidden' => 'getHidden',
'position' => 'getPosition',
'label' => 'getLabel',
'editor' => 'getEditor',
'set_id' => 'getSetId',
'multiple' => 'getMultiple',
'parent' => 'getParent',
'string_values' => 'getStringValues',
'value' => 'getValue'    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['string_value'] = isset($data['string_value']) ? $data['string_value'] : null;
        $this->container['int_value'] = isset($data['int_value']) ? $data['int_value'] : null;
        $this->container['double_value'] = isset($data['double_value']) ? $data['double_value'] : null;
        $this->container['date_value'] = isset($data['date_value']) ? $data['date_value'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['mandatory'] = isset($data['mandatory']) ? $data['mandatory'] : null;
        $this->container['hidden'] = isset($data['hidden']) ? $data['hidden'] : null;
        $this->container['position'] = isset($data['position']) ? $data['position'] : null;
        $this->container['label'] = isset($data['label']) ? $data['label'] : null;
        $this->container['editor'] = isset($data['editor']) ? $data['editor'] : null;
        $this->container['set_id'] = isset($data['set_id']) ? $data['set_id'] : null;
        $this->container['multiple'] = isset($data['multiple']) ? $data['multiple'] : null;
        $this->container['parent'] = isset($data['parent']) ? $data['parent'] : null;
        $this->container['string_values'] = isset($data['string_values']) ? $data['string_values'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets string_value
     *
     * @return string
     */
    public function getStringValue()
    {
        return $this->container['string_value'];
    }

    /**
     * Sets string_value
     *
     * @param string $string_value string_value
     *
     * @return $this
     */
    public function setStringValue($string_value)
    {
        $this->container['string_value'] = $string_value;

        return $this;
    }

    /**
     * Gets int_value
     *
     * @return int
     */
    public function getIntValue()
    {
        return $this->container['int_value'];
    }

    /**
     * Sets int_value
     *
     * @param int $int_value int_value
     *
     * @return $this
     */
    public function setIntValue($int_value)
    {
        $this->container['int_value'] = $int_value;

        return $this;
    }

    /**
     * Gets double_value
     *
     * @return double
     */
    public function getDoubleValue()
    {
        return $this->container['double_value'];
    }

    /**
     * Sets double_value
     *
     * @param double $double_value double_value
     *
     * @return $this
     */
    public function setDoubleValue($double_value)
    {
        $this->container['double_value'] = $double_value;

        return $this;
    }

    /**
     * Gets date_value
     *
     * @return string
     */
    public function getDateValue()
    {
        return $this->container['date_value'];
    }

    /**
     * Sets date_value
     *
     * @param string $date_value date_value
     *
     * @return $this
     */
    public function setDateValue($date_value)
    {
        $this->container['date_value'] = $date_value;

        return $this;
    }

    /**
     * Gets type
     *
     * @return int
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param int $type type
     *
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets mandatory
     *
     * @return int
     */
    public function getMandatory()
    {
        return $this->container['mandatory'];
    }

    /**
     * Sets mandatory
     *
     * @param int $mandatory mandatory
     *
     * @return $this
     */
    public function setMandatory($mandatory)
    {
        $this->container['mandatory'] = $mandatory;

        return $this;
    }

    /**
     * Gets hidden
     *
     * @return int
     */
    public function getHidden()
    {
        return $this->container['hidden'];
    }

    /**
     * Sets hidden
     *
     * @param int $hidden hidden
     *
     * @return $this
     */
    public function setHidden($hidden)
    {
        $this->container['hidden'] = $hidden;

        return $this;
    }

    /**
     * Gets position
     *
     * @return int
     */
    public function getPosition()
    {
        return $this->container['position'];
    }

    /**
     * Sets position
     *
     * @param int $position position
     *
     * @return $this
     */
    public function setPosition($position)
    {
        $this->container['position'] = $position;

        return $this;
    }

    /**
     * Gets label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->container['label'];
    }

    /**
     * Sets label
     *
     * @param string $label label
     *
     * @return $this
     */
    public function setLabel($label)
    {
        $this->container['label'] = $label;

        return $this;
    }

    /**
     * Gets editor
     *
     * @return int
     */
    public function getEditor()
    {
        return $this->container['editor'];
    }

    /**
     * Sets editor
     *
     * @param int $editor editor
     *
     * @return $this
     */
    public function setEditor($editor)
    {
        $this->container['editor'] = $editor;

        return $this;
    }

    /**
     * Gets set_id
     *
     * @return int
     */
    public function getSetId()
    {
        return $this->container['set_id'];
    }

    /**
     * Sets set_id
     *
     * @param int $set_id set_id
     *
     * @return $this
     */
    public function setSetId($set_id)
    {
        $this->container['set_id'] = $set_id;

        return $this;
    }

    /**
     * Gets multiple
     *
     * @return int
     */
    public function getMultiple()
    {
        return $this->container['multiple'];
    }

    /**
     * Sets multiple
     *
     * @param int $multiple multiple
     *
     * @return $this
     */
    public function setMultiple($multiple)
    {
        $this->container['multiple'] = $multiple;

        return $this;
    }

    /**
     * Gets parent
     *
     * @return string
     */
    public function getParent()
    {
        return $this->container['parent'];
    }

    /**
     * Sets parent
     *
     * @param string $parent parent
     *
     * @return $this
     */
    public function setParent($parent)
    {
        $this->container['parent'] = $parent;

        return $this;
    }

    /**
     * Gets string_values
     *
     * @return string
     */
    public function getStringValues()
    {
        return $this->container['string_values'];
    }

    /**
     * Sets string_values
     *
     * @param string $string_values string_values
     *
     * @return $this
     */
    public function setStringValues($string_values)
    {
        $this->container['string_values'] = $string_values;

        return $this;
    }

    /**
     * Gets value
     *
     * @return object
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param object $value value
     *
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
