<?php
/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;
?>
<script type="text/javascript">

    $(document).ready(function () {

        $('#new, .delete, .edit').button();

        $('.test').button().click(function () {
            var id = $(this).attr('data-id');
            $.ajax({
                type: 'GET',
                url: 'index.php',
                data: {
                    option: 'com_logicaldoc',
                    view: 'configuration',
                    task: 'test',
                    format: 'raw',
                    id: id,
                },
                datatype: 'html',
                success: function (data) {
                    $('#testData').html(data);
                }
            });
        });

        $('#tablaConfiguration').dataTable({
            "bJQueryUI": true,
            "sPaginationType": "full_numbers",
            "iDisplayLength": 25,
            "bFilter": true,
            "aoColumns": [
                {"bSortable": true},
                {"bSortable": true},
                {"bSortable": true},
                {"bSortable": true},
                {"bSortable": true},
                {"bSortable": false, "bSearchable": false},
                {"bSortable": false, "bSearchable": false}
            ],
            "aaSorting": [[0, "asc"]],
            "oLanguage": {
                "sProcessing": "<?php echo JText::_('COM_LOGICALDOC_PLEASE_WAIT') ?>",
                "sLengthMenu": "<?php echo JText::_('COM_LOGICALDOC_SHOW') ?>_MENU_ <?php echo JText::_('COM_LOGICALDOC_ENTRIES') ?>",
                                "sZeroRecords": "<?php echo JText::_('COM_LOGICALDOC_NOTHING_FOUND_SORRY') ?>",
                                "sInfo": "<?php echo JText::_('COM_LOGICALDOC_SHOWING') ?>_START_ <?php echo JText::_('COM_LOGICALDOC_TO') ?> _END_ <?php echo JText::_('COM_LOGICALDOC_OF') ?> _TOTAL_ <?php echo JText::_('COM_LOGICALDOC_ENTRIES') ?>",
                                                "sInfoEmpty": "<?php echo JText::_('COM_LOGICALDOC_SHOWING') ?> 0 <?php echo JText::_('COM_LOGICALDOC_TO') ?> 0 <?php echo JText::_('COM_LOGICALDOC_OF') ?> 0 <?php echo JText::_('COM_LOGICALDOC_ENTRIES') ?>",
                                                                "sInfoFiltered": "(<?php echo JText::_('COM_LOGICALDOC_FILTERED_FROM') ?> _MAX_ <?php echo JText::_('COM_LOGICALDOC_TOTAL_ENTRIES') ?>)",
                                                                "sInfoPostFix": "",
                                                                "sSearch": "<?php echo JText::_('COM_LOGICALDOC_SEARCH'); ?>",
                                                                "sUrl": "",
                                                                "oPaginate": {
                                                                    "sFirst": "<?php echo JText::_('COM_LOGICALDOC_FIRST') ?>",
                                                                    "sPrevious": "<?php echo JText::_('COM_LOGICALDOC_PREVIOUS') ?>",
                                                                    "sNext": "<?php echo JText::_('COM_LOGICALDOC_NEXT') ?>",
                                                                    "sLast": "<?php echo JText::_('COM_LOGICALDOC_LAST') ?>"
                                                                }
                                                            }
                                                        });


                                                    });
</script>
<p align="right">
    <a id="new" title="<?php echo JText::_('COM_LOGICALDOC_NEW'); ?>" href="index.php?option=com_logicaldoc&view=configuration&layout=formconfiguration">
        <i class="fa fa-plus fa-3x"></i>        
    </a>
</p>
<div id="testData" class="panel panel-default">
    
</div>
<table id="tablaConfiguration" width="100%" class="display" cellpadding="0" cellspacing="0" border="0">
    <thead>
        <tr>
            <th><?php echo JText::_('COM_LOGICALDOC_NAME') ?></th>
            <th><?php echo JText::_('COM_LOGICALDOC_USER') ?></th>
            <th>URL</th>
            <th><?php echo JText::_('COM_LOGICALDOC_PATH'); ?></th>
            <th><?php echo JText::_('COM_LOGICALDOC_ACCESS'); ?></th>            
            <th width="150px"><?php echo JText::_('COM_LOGICALDOC_ACTION'); ?></th>
            <th width="100px"><?php echo JText::_('COM_LOGICALDOC_CONNECTION'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($this->rows as $row) { ?>
            <tr>
                <td>
                    <?php echo $row->name; ?>
                </td>
                <td>
                    <?php echo $row->user; ?>                        
                </td>                   
                <td>
                    <?php echo $row->url; ?>                        
                </td>
                <td>
                    <?php echo $row->ldocPath; ?>
                </td>
                <td align="center">
                    <?php echo $row->access; ?>                  
                </td>
                <td align="center">
                    <a class="delete" title="<?php echo JText::_('COM_LOGICALDOC_DELETE'); ?>" href="index.php?option=com_logicaldoc&view=configuration&task=delete&id=<?php echo $row->idConfiguration; ?>" >
                        <i class="fa fa-trash"></i>                        
                    </a>
                    <a class="edit" title="<?php echo JText::_('COM_LOGICALDOC_EDIT') ?>" href="index.php?option=com_logicaldoc&view=configuration&task=edit&id=<?php echo $row->idConfiguration; ?>" >
                        <i class="fa fa-edit"></i>                        
                    </a>
                </td>
                <td align="center">
                    <a class="test" title="<?php echo JText::_('COM_LOGICALDOC_TEST_CONNECTION') ?>" href="#" data-id="<?php echo $row->idConfiguration; ?>">
                        <i class="fa fa-cog"></i>                        
                        <?php echo JText::_('COM_LOGICALDOC_TEST') ?> 
                    </a>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>