<?php

/**
 * Copyright (c) 2006-2022 LogicalDOC
 * WebSites: www.logicaldoc.com
 * 
 * No bytes were intentionally harmed during the development of this application.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

class LogicalDOCViewConfiguration extends JViewLegacy {

    public function display($tpl = null) {
        $document = JFactory::getDocument();
        $host = JURI::root();

        $document->addStyleSheet($host . '/administrator/components/com_logicaldoc/assets/css/normalize.css');
        $document->addStyleSheet($host . '/administrator/components/com_logicaldoc/assets/css/fortawesome/font-awesome.min.css');
        $document->addStyleSheet($host . '/administrator/components/com_logicaldoc/assets/css/jqueryui/jquery-ui-1.11.4.min.css');
        $document->addStyleSheet($host . '/administrator/components/com_logicaldoc/assets/css/datatables/dataTables.jqueryui.css');
        $document->addStyleSheet($host . '/administrator/components/com_logicaldoc/assets/css/validationEngine.jquery.css');
        $document->addStyleSheet($host . '/administrator/components/com_logicaldoc/assets/css/icheck/all.css');
        $document->addStyleSheet($host . '/administrator/components/com_logicaldoc/assets/css/style.css');

        $document->addScript($host . '/administrator/components/com_logicaldoc/assets/js/jquery-1.11.2.min.js');
        $document->addScript($host . '/administrator/components/com_logicaldoc/assets/js/jquery-ui-1.11.4.min.js');
        $document->addScript($host . '/administrator/components/com_logicaldoc/assets/js/jquery.ui.datepicker-es.js');
        $document->addScript($host . '/administrator/components/com_logicaldoc/assets/js/validador/jquery.validationEngine-en.js');
        $document->addScript($host . '/administrator/components/com_logicaldoc/assets/js/validador/jquery.validationEngine.js');
        $document->addScript($host . '/administrator/components/com_logicaldoc/assets/js/datatables/jquery.dataTables.min.js');
        $document->addScript($host . '/administrator/components/com_logicaldoc/assets/js/datatables/dataTables.jqueryui.min.js');
        $document->addScript($host . '/administrator/components/com_logicaldoc/assets/js/jquery.icheck.js');

        $layout = JRequest::getVar('layout');
        if ($layout == 'formconfiguration') {
            $idConfiguration = JRequest::getVar('id');
            require_once (JPATH_COMPONENT . DS . 'tables' . DS . 'configuration.php');
            $row = JTable::getInstance('Configuration', 'Table');
            $row->load($idConfiguration);
            $this->assignRef('row', $row);

            require_once (JPATH_COMPONENT . DS . 'models' . DS . 'configuration.php');
            $modelConfiguration = new LogicalDOCModelConfiguration();
            $rows = $modelConfiguration->getObjects();
            $this->assignRef('rows', $rows);
            //Metadata
            require_once (JPATH_COMPONENT . DS . 'models' . DS . 'metadata.php');
            $modelMetadata = new LogicalDOCModelMetadata();
            $rowsMetadata = $modelMetadata->getObjects($idConfiguration);
            $this->assignRef('rowsMetadata', $rowsMetadata);
            if (empty($rowsMetadata)) {
                $size = 0;
            } else {
                $size = count($rowsMetadata);
            }
            $this->assignRef('size', $size);
        } else if ($layout == 'listconfiguration') {
            require_once (JPATH_COMPONENT . DS . 'models' . DS . 'configuration.php');
            $modelConfiguration = new LogicalDOCModelConfiguration();
            $rows = $modelConfiguration->getObjects();
            $this->assignRef('rows', $rows);
        }
        // Set the toolbar		
        $this->addToolBar();
        parent::display($tpl);
    }

    protected function addToolBar() {
        JToolBarHelper::title('LogicalDOC');
    }

}

?>
