<?php
/**
 * @package     FILEman
 * @copyright   Copyright (C) 2020 Timble CVBA. (http://www.timble.net)
 * @license     GNU GPLv3 <http://www.gnu.org/licenses/gpl.html>
 * @link        http://www.joomlatools.com
 */

class ComFilemanTemplateHelperSlider extends ComKoowaTemplateHelperBehavior
{
    /**
     * Load Splide slider
     * 
     * @param array $config
     * @return string
     */
    public function load($config = array())
    {
        $config = new KObjectConfigJson($config);
        $config->append([
            'selector' => '.mod_fileman--slider',
            'options'  => [
                'type'  => 'loop',
                'focus' => 'center',
                'gap'   => '1rem'
            ]
        ]);

        $html = $this->jquery();

        $signature = md5(serialize([$config->selector, $config->options]));

        if (!static::isLoaded($signature))
        {
            $html .= '<ktml:style src="media://com_fileman/css/splide.css"/>
            <ktml:style src="media://com_fileman/css/splide-extension-video.css"/>
            <ktml:script src="media://com_fileman/js/splide.js" />
            <ktml:script src="media://com_fileman/js/splide-extension-video.js" />';

            $html .= '<script>
            kQuery(function($) {
                new Splide("' . $config->selector . '", ' . $config->options . ').mount(window.splide.Extensions);
            });</script>';

            static::setLoaded($signature);
        }

        return $html;
    }
}