<?php
/**
 * @license    License compatible with GNU General Public License (GNU GPL); see file LICENSE
 */


namespace GuzzleHttp\Promise;

defined('_JEXEC') or die('Restricted access');


/**
 * Exception thrown when too many errors occur in the some() or any() methods.
 */
class AggregateException extends RejectionException
{
    public function __construct($msg, array $reasons)
    {
        parent::__construct(
            $reasons,
            sprintf('%s; %d rejected promises', $msg, count($reasons))
        );
    }
}
